/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id: lcd-player-charset.c,v 1.9 2005/05/23 12:04:30 bagder Exp $
 *
 * Copyright (C) 2003 by Kjell Ericson
 *
 * All files in this archive are subject to the GNU General Public License.
 * See the file COPYING in the source tree root for full license agreement.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/
#ifndef __CONFIG_H__
/* to easier allow this source file to be used even from tools when config.h
   cannot be included safely */
#include "config.h"
#endif

#ifdef HAVE_LCD_CHARCELLS

#include "lcd-player-charset.h"

unsigned short new_lcd_rocklatin1_to_xlcd[] =
{
   NOCHAR_NEW,    /* 0x00 reserved never to be used */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   0x216, /* 0x16 .. "bookmark" icon */
   0x217, /* 0x17 .. "plugin" icon */
   0x218, /* 0x18 .. "folder" icon */
   0x219, /* 0x19 .. "MOD/AJZ" icon (winlatin o (dote in the middle) */
   0x21a, /* 0x1a .. "language" icon (winlatin - (a bit longer minus sign) */
   0x21b, /* 0x1b .. "note" icon */
   0x21c, /* 0x1c .. "WPS" icon */
   0x21d, /* 0x1d .. "playlist" icon */
   0x21e, /* 0x1e .. "text file" icon (winlatin - (much longer minus sign) */
   0x21f, /* 0x1f .. "config file" icon (winlatin ~) */

   0x020, /* 0x20 ..   */
   0x021, /* 0x21 .. ! */
   0x022, /* 0x22 .. " */
   0x023, /* 0x23 .. # */
   0x024, /* 0x24 .. $ */
   0x025, /* 0x25 .. % */
   0x026, /* 0x26 .. & */
   0x027, /* 0x27 .. ' */
   0x028, /* 0x28 .. ( */
   0x029, /* 0x29 .. ) */
   0x02a, /* 0x2a .. * */
   0x02b, /* 0x2b .. + */
   0x02c, /* 0x2c .. , */
   0x02d, /* 0x2d .. - */
   0x02e, /* 0x2e .. . */
   0x02f, /* 0x2f .. / */
   0x030, /* 0x30 .. 0 */
   0x031, /* 0x31 .. 1 */
   0x032, /* 0x32 .. 2 */
   0x033, /* 0x33 .. 3 */
   0x034, /* 0x34 .. 4 */
   0x035, /* 0x35 .. 5 */
   0x036, /* 0x36 .. 6 */
   0x037, /* 0x37 .. 7 */
   0x038, /* 0x38 .. 8 */
   0x039, /* 0x39 .. 9 */
   0x03a, /* 0x3a .. : */
   0x03b, /* 0x3b .. ; */
   0x03c, /* 0x3c .. < */
   0x03d, /* 0x3d .. = */
   0x03e, /* 0x3e .. > */
   0x03f, /* 0x3f .. ? */
   0x040, /* 0x40 .. @ */
   0x041, /* 0x41 .. A */
   0x042, /* 0x42 .. B */
   0x043, /* 0x43 .. C */
   0x044, /* 0x44 .. D */
   0x045, /* 0x45 .. E */
   0x046, /* 0x46 .. F */
   0x047, /* 0x47 .. G */
   0x048, /* 0x48 .. H */
   0x049, /* 0x49 .. I */
   0x04a, /* 0x4a .. J */
   0x04b, /* 0x4b .. K */
   0x04c, /* 0x4c .. L */
   0x04d, /* 0x4d .. M */
   0x04e, /* 0x4e .. N */
   0x04f, /* 0x4f .. O */
   0x050, /* 0x50 .. P */
   0x051, /* 0x51 .. Q */
   0x052, /* 0x52 .. R */
   0x053, /* 0x53 .. S */
   0x054, /* 0x54 .. T */
   0x055, /* 0x55 .. U */
   0x056, /* 0x56 .. V */
   0x057, /* 0x57 .. W */
   0x058, /* 0x58 .. X */
   0x059, /* 0x59 .. Y */
   0x05a, /* 0x5a .. Z */
   0x05b, /* 0x5b .. [ */
   0x012, /* 0x5c .. \ */
   0x05d, /* 0x5d .. ] */
   0x05e, /* 0x5e .. ^ */
   0x05f, /* 0x5f .. _ */
   0x060, /* 0x60 .. ` */
   0x061, /* 0x00 97 .. a */
   0x062, /* 0x00 98 .. b */
   0x063, /* 0x00 99 .. c */
   0x064, /* 0x64 .. d */
   0x065, /* 0x65 .. e */
   0x066, /* 0x66 .. f */
   0x067, /* 0x67 .. g */
   0x068, /* 0x68 .. h */
   0x069, /* 0x69 .. i */
   0x06a, /* 0x6a .. j */
   0x06b, /* 0x6b .. k */
   0x06c, /* 0x6c .. l */
   0x06d, /* 0x6d .. m */
   0x06e, /* 0x6e .. n */
   0x06f, /* 0x6f .. o */
   0x070, /* 0x70 .. p */
   0x071, /* 0x71 .. q */
   0x072, /* 0x72 .. r */
   0x073, /* 0x73 .. s */
   0x074, /* 0x74 .. t */
   0x075, /* 0x75 .. u */
   0x076, /* 0x76 .. v */
   0x077, /* 0x77 .. w */
   0x078, /* 0x78 .. x */
   0x079, /* 0x79 .. y */
   0x07a, /* 0x7a .. z */
   0x07b, /* 0x7b ..*/ /* Old LCD hardcoded to "(" */
   0x07c, /* 0x7c .. | */
   0x07d, /* 0x7d .. } */ /* Old LCD hardcoded to ")" */
   0x0f0, /* 0x7e .. ~ */
   0x0fe, /* 0x7f .. full grid */
   NOCHAR_NEW, /* 0x80 winlatin Eurosign */
   0x010, /* 0x81 filled-left-arrow (winlatin undefined) */
   0x011, /* 0x82 filled-right-arrow (winlatin comma) */
   0x01e, /* 0x83 filled-up-arrow (winlatin f)  */
   0x01f, /* 0x84 filled-up-arrow (winlatin ") */
   0x224, /* 0x85 ..  (three dots) */
   0x081, /* 0x86 meter level 2 (winlatin undefined) */
   0x082, /* 0x87 meter level 3 (winlatin undefined) */
   0x083, /* 0x88 meter level 4 (winlatin undefined) */
   0x084, /* 0x89 meter level 5 (winlatin Promille) */
   0x085, /* 0x8a meter level 6 (winlatin 'S' with upside down ^) */
   0x086, /* 0x8b meter level 7 (full) (winlatin '<') */
   NOCHAR_NEW, /* 0x8c ..  CE */
   NOCHAR_NEW, /* 0x8d ..  */
   0x225, /* 0x8e ..  'Z' with upside down ^ */
   NOCHAR_NEW, /* 0x8f ..  */
   0x25d, /* 0x90 "unknown" icon  */
   0x094, /* 0x91 ..  */
   0x07e, /* 0x92 ..  */
   0x091, /* 0x93 ..  folder icon susbstitute */
   0x013, /* 0x94 ..  note icon substitute */
   0x0d0, /* 0x95 .. text/language/config icon substitute (winlatin o (dote in the middle) */
   NOCHAR_NEW, /* 0x96 .. (winlatin - (a bit longer minus sign) */
   NOCHAR_NEW, /* 0x97 .. (winlatin - (much longer minus sign) */
   NOCHAR_NEW, /* 0x98 .. (winlatin ~) */
   NOCHAR_NEW, /* 0x99 .. (winlatin TM) */
   NOCHAR_NEW, /* 0x9a ..  's' with upside down ^ */
   NOCHAR_NEW, /* 0x9b ..  > */
   NOCHAR_NEW, /* 0x9c ..  oe */
   NOCHAR_NEW, /* 0x9d ..  */
   0x225,      /* 0x9e ..  'z' with upside down ^ */
   0x059,      /* 0x9f ..  Large  (Y with two dots) */
   NOCHAR_NEW, /* 0xa0 ..   */
   NOCHAR_NEW, /* 0xa1 ..  */
   NOCHAR_NEW, /* 0xa2 ..  */
   0x226,      /* 0xa3 ..  */
   NOCHAR_NEW, /* 0xa4 ..  */
   NOCHAR_NEW, /* 0xa5 ..  */
   NOCHAR_NEW, /* 0xa6 ..  */
   0x015,      /* 0xa7 ..  */
   NOCHAR_NEW, /* 0xa8 ..  */
   NOCHAR_NEW, /* 0xa9 ..  (copyright) */
   NOCHAR_NEW, /* 0xaa ..  */
   NOCHAR_NEW, /* 0xab .. "<<" */
   NOCHAR_NEW, /* 0xac .. (unknown) */
   NOCHAR_NEW, /* 0xad .. (unkown1 */
   NOCHAR_NEW, /* 0xae ..  (register)*/
   0x228,      /* 0xaf ..  */
   NOCHAR_NEW, /* 0xb0 ..  */
   NOCHAR_NEW, /* 0xb1 ..  */
   NOCHAR_NEW, /* 0xb2 ..  */
   NOCHAR_NEW, /* 0xb3 ..  */
   NOCHAR_NEW, /* 0xb4 ..  */
   NOCHAR_NEW, /* 0xb5 ..  */
   NOCHAR_NEW, /* 0xb6 .. 1 */
   NOCHAR_NEW, /* 0xb7 ..  */
   NOCHAR_NEW, /* 0xb8 ..  */
   NOCHAR_NEW, /* 0xb9 ..  */
   NOCHAR_NEW, /* 0xba ..  */
   NOCHAR_NEW, /* 0xbb .. " */
   NOCHAR_NEW, /* 0xbc ..  */
   NOCHAR_NEW, /* 0xbd ..  */
   NOCHAR_NEW, /* 0xbe ..  */
   0x229,      /* 0xbf ..  */
   0x22a, /* 0xc0 ..  */
   0x22b, /* 0xc1 ..  */
   0x22c, /* 0xc2 ..  */
   0x22d, /* 0xc3 ..  */
   0x22e, /* 0xc4 ..  */
   0x22f, /* 0xc5 ..  */
   0x230, /* 0xc6 ..  */
   0x231, /* 0xc7 ..  */
   0x232, /* 0xc8 ..  */
   0x233, /* 0xc9 ..  */
   0x234, /* 0xca ..  */
   0x235, /* 0xcb ..  */
   0x236, /* 0xcc ..  */
   0x237, /* 0xcd ..  */
   0x049, /* 0xce ..  */
   0x049, /* 0xcf ..  */
   0x238, /* 0xd0 ..  */
   0x239, /* 0xd1 ..  */
   0x23a, /* 0xd2 ..  */
   0x23b, /* 0xd3 ..  */
   0x23c, /* 0xd4 ..  */
   0x23d, /* 0xd5 ..  */
   0x23e, /* 0xd6 ..  */
   0x23f, /* 0xd7 ..  */
   0x240, /* 0xd8 ..  */
   0x241, /* 0xd9 ..  */
   0x242, /* 0xda ..  */
   0x055, /* 0xdb ..  */
   0x243, /* 0xdc ..  */
   0x059, /* 0xdd ..  */
   NOCHAR_NEW, /* 0xde ..  */
   0x244, /* 0xdf ..  */
   0x245, /* 0xe0 ..  */
   0x246, /* 0xe1 ..  */
   0x247, /* 0xe2 ..  */
   0x248, /* 0xe3 ..  */
   0x249, /* 0xe4 ..  */
   0x24a, /* 0xe5 ..  */
   NOCHAR_NEW, /* 0xe6 ..  */
   0x24b, /* 0xe7 ..  */
   0x24c, /* 0xe8 ..  */
   0x24d, /* 0xe9 ..  */
   0x24e, /* 0xea ..  */
   0x24f, /* 0xeb ..  */
   0x069, /* 0xec ..  */
   0x250, /* 0xed ..  */
   0x251, /* 0xee ..  */
   0x252, /* 0xef ..  */
   NOCHAR_NEW, /* 0xf0 ..  */
   0x253, /* 0xf1 ..  */
   0x23a, /* 0xf2 ..  */
   0x254, /* 0xf3 ..  */
   0x255, /* 0xf4 ..  */
   0x256, /* 0xf5 ..  */
   0x257, /* 0xf6 ..  */
   NOCHAR_NEW, /* 0xf7 ..  */
   0x258, /* 0xf8 ..  */
   0x259, /* 0xf9 ..  */
   0x25a, /* 0xfa ..  */
   0x075, /* 0xfb ..  */
   0x25b, /* 0xfc ..  */
   0x25c, /* 0xfd ..  */
   NOCHAR_NEW, /* 0xfe ..  */
   0x079, /* 0xff ..  */
};

unsigned short old_lcd_rocklatin1_to_xlcd[] =
{
   /* OLD LCD */
   NOCHAR_OLD, /* 0x00 reserved never to be used */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   RESERVED_CHAR, /* reserved */
   0x216, /* 0x16 .. "bookmark" icon */
   0x217, /* 0x17 .. "plugin" icon */
   0x218, /* 0x18 .. "folder" icon */
   0x219, /* 0x19 .. "MOD/AJZ" icon (winlatin o (dote in the middle) */
   0x21a, /* 0x1a .. "language" icon (winlatin - (a bit longer minus sign) */
   0x0fc, /* 0x1b .. "note" icon */
   0x0d4, /* 0x1c .. "WPS" icon */
   0x21d, /* 0x1d .. "playlist" icon */
   0x21e, /* 0x1e .. "text file" icon (winlatin - (much longer minus sign) */
   0x21f, /* 0x1f .. "config file" icon (winlatin ~) */
   0x024,  /* 0x20 ..   */
   0x025,  /* 0x21 .. ! */
   0x026,  /* 0x22 .. " */
   0x027,  /* 0x23 .. # */
   0x006,  /* 0x24 .. $ */
   0x029,  /* 0x25 .. % */
   0x02a,  /* 0x26 .. & */
   0x02b,  /* 0x27 .. ' */
   0x02c,  /* 0x28 .. ( */
   0x02d,  /* 0x29 .. ) */
   0x02e,  /* 0x2a .. * */
   0x02f,  /* 0x2b .. + */
   0x030,  /* 0x2c .. , */
   0x031,  /* 0x2d .. - */
   0x032,  /* 0x2e .. . */
   0x033,  /* 0x2f .. / */
   0x034,  /* 0x30 .. 0 */
   0x035,  /* 0x31 .. 1 */
   0x036,  /* 0x32 .. 2 */
   0x037,  /* 0x33 .. 3 */
   0x038,  /* 0x34 .. 4 */
   0x039,  /* 0x35 .. 5 */
   0x03a,  /* 0x36 .. 6 */
   0x03b,  /* 0x37 .. 7 */
   0x03c,  /* 0x38 .. 8 */
   0x03d,  /* 0x39 .. 9 */
   0x03e,  /* 0x3a .. : */
   0x03f,  /* 0x3b .. ; */
   0x040,  /* 0x3c .. < */
   0x041,  /* 0x3d .. = */
   0x042,  /* 0x3e .. > */
   0x043,  /* 0x3f .. ? */
   0x004,  /* 0x40 .. @ */
   0x045,  /* 0x41 .. A */
   0x046,  /* 0x42 .. B */
   0x047,  /* 0x43 .. C */
   0x048,  /* 0x44 .. D */
   0x049,  /* 0x45 .. E */
   0x04a,  /* 0x46 .. F */
   0x04b,  /* 0x47 .. G */
   0x04c,  /* 0x48 .. H */
   0x04d,  /* 0x49 .. I */
   0x04e,  /* 0x4a .. J */
   0x04f,  /* 0x4b .. K */
   0x050,  /* 0x4c .. L */
   0x051,  /* 0x4d .. M */
   0x052,  /* 0x4e .. N */
   0x053,  /* 0x4f .. O */
   0x054,  /* 0x50 .. P */
   0x055,  /* 0x51 .. Q */
   0x056,  /* 0x52 .. R */
   0x057,  /* 0x53 .. S */
   0x058,  /* 0x54 .. T */
   0x059,  /* 0x55 .. U */
   0x05a,  /* 0x56 .. V */
   0x05b,  /* 0x57 .. W */
   0x05c,  /* 0x58 .. X */
   0x05d,  /* 0x59 .. Y */
   0x05e,  /* 0x5a .. Z */
   0x0a9,  /* 0x5b .. [ */ /* New LCD hardcoded to "(" */
   0x220,  /* 0x5c .. \ */
   0x0ce,  /* 0x5d .. ] */ /* New LCD hardcoded to ")" */
   NOCHAR_OLD,  /* 0x5e .. ^ */
   0x015,  /* 0x5f .. _ */
   0x221,  /* 0x60 .. ` */
   0x065,  /* 0x00 97 .. a */
   0x066,  /* 0x00 98 .. b */
   0x067,  /* 0x00 99 .. c */
   0x068,  /* 0x64 .. d */
   0x069,  /* 0x65 .. e */
   0x06a,  /* 0x66 .. f */
   0x06b,  /* 0x67 .. g */
   0x06c,  /* 0x68 .. h */
   0x06d,  /* 0x69 .. i */
   0x06e,  /* 0x6a .. j */
   0x06f,  /* 0x6b .. k */
   0x070,  /* 0x6c .. l */
   0x071,  /* 0x6d .. m */
   0x072,  /* 0x6e .. n */
   0x073,  /* 0x6f .. o */
   0x074,  /* 0x70 .. p */
   0x075,  /* 0x71 .. q */
   0x076,  /* 0x72 .. r */
   0x077,  /* 0x73 .. s */
   0x078,  /* 0x74 .. t */
   0x079,  /* 0x75 .. u */
   0x07a,  /* 0x76 .. v */
   0x07b,  /* 0x77 .. w */
   0x07c,  /* 0x78 .. x */
   0x07d,  /* 0x79 .. y */
   0x07e,  /* 0x7a .. z */
   0x02c,  /* 0x7b ..*/ /* Old LCD hardcoded to "(" */
   0x222,  /* 0x7c .. | */
   0x02d,  /* 0x7d .. } */ /* Old LCD hardcoded to ")" */
   0x223,  /* 0x7e .. ~ */
   0x08b,  /* 0x7f full grid */
   NOCHAR_OLD, /* 0x80 winlatin Eurosign */
   0x089, /* 0x81 filled-left-arrow (winlatin undefined) */
   0x088, /* 0x82 filled-right-arrow (winlatin comma) */
   0x087, /* 0x83 filled-up-arrow (winlatin f)  */
   0x086, /* 0x84 filled-up-arrow (winlatin ") */
   0x085,  /* 0x85 ..  (three dots) */
   0x0df, /* 0x86 meter level 2 (winlatin undefined) */
   0x0e0, /* 0x87 meter level 3 (winlatin undefined) */
   0x0e1, /* 0x88 meter level 4 (winlatin undefined) */
   0x0e2, /* 0x89 meter level 5 (winlatin Promille) */
   0x0e3, /* 0x8a meter level 6 (winlatin 'S' with upside down ^) */
   0x0ec, /* 0x8a meter level 7 (full) (winlatin '<') */
   NOCHAR_OLD,  /* 0x8c ..  CE */
   NOCHAR_OLD,  /* 0x8d ..  */
   0x0bd,       /* 0x8e ..  'Z' with upside down ^ */
   NOCHAR_OLD,  /* 0x8f ..  */
   0x25d, /* 0x90 "unknown" icon  */
   0x0d4, /* 0x91 ..  */
   0x089, /* 0x92 ..  */
   0x034, /* 0x93 ..  folder icon substitute */
   0x0fc, /* 0x94 ..  note icon substitute */
   0x0fa, /* 0x95 .. text/language/config icon substitute (winlatin o (dote in the middle) */
   NOCHAR_OLD, /* 0x96 .. (winlatin - (a bit longer minus sign) */
   NOCHAR_OLD, /* 0x97 .. (winlatin - (much longer minus sign) */
   NOCHAR_OLD, /* 0x98 .. (winlatin ~) */
   NOCHAR_OLD, /* 0x99 .. (winlatin TM) */
   NOCHAR_OLD,  /* 0x9a ..  's' with upside down ^ */
   NOCHAR_OLD,  /* 0x9b ..  > */
   NOCHAR_OLD,  /* 0x9c ..  oe */
   NOCHAR_OLD,  /* 0x9d ..  */
   0x0bd,       /* 0x9e ..  'z' with upside down ^ */
   NOCHAR_OLD,  /* 0x9f ..  Large  (Y with two dots) */
   NOCHAR_OLD,  /* 0xa0 ..   */
   NOCHAR_OLD,  /* 0xa1 ..  */
   NOCHAR_OLD,  /* 0xa2 ..  */
   0x005,       /* 0xa3 ..  */
   NOCHAR_OLD,  /* 0xa4 ..  */
   NOCHAR_OLD,  /* 0xa5 ..  */
   NOCHAR_OLD,  /* 0xa6 ..  */
   0x063,       /* 0xa7 ..  */
   NOCHAR_OLD,  /* 0xa8 ..  */
   NOCHAR_OLD,  /* 0xa9 ..  (copyright) */
   NOCHAR_OLD,  /* 0xaa ..  */
   NOCHAR_OLD,  /* 0xab .. "<<" */
   NOCHAR_OLD,  /* 0xac .. (unknown) */
   NOCHAR_OLD,  /* 0xad .. (unkown1 */
   NOCHAR_OLD,  /* 0xae ..  (register)*/
   0x0ee,       /* 0xaf ..  */
   NOCHAR_OLD,  /* 0xb0 ..  */
   NOCHAR_OLD,  /* 0xb1 ..  */
   NOCHAR_OLD,  /* 0xb2 ..  */
   NOCHAR_OLD,  /* 0xb3 ..  */
   NOCHAR_OLD,  /* 0xb4 ..  */
   NOCHAR_OLD,  /* 0xb5 ..  */
   NOCHAR_OLD,  /* 0xb6 .. 1 */
   NOCHAR_OLD,  /* 0xb7 ..  */
   NOCHAR_OLD,  /* 0xb8 ..  */
   NOCHAR_OLD,  /* 0xb9 ..  */
   NOCHAR_OLD,  /* 0xba ..  */
   NOCHAR_OLD,  /* 0xbb .. " */
   NOCHAR_OLD,  /* 0xbc ..  */
   NOCHAR_OLD,  /* 0xbd ..  */
   NOCHAR_OLD,  /* 0xbe ..  */
   0x064,  /* 0xbf ..  */
   0x08c,  /* 0xc0 ..  */
   0x08d,  /* 0xc1 ..  */
   0x08e,  /* 0xc2 ..  */
   0x08f,  /* 0xc3 ..  */
   0x05f,  /* 0xc4 ..  */
   0x012,  /* 0xc5 ..  */
   0x020,  /* 0xc6 ..  */
   0x00d,  /* 0xc7 ..  */
   0x090,  /* 0xc8 ..  */
   0x023,  /* 0xc9 ..  */
   0x091,  /* 0xca ..  */
   0x092,  /* 0xcb ..  */
   0x093,  /* 0xcc ..  */
   0x094,  /* 0xcd ..  */
   0x049,  /* 0xce ..  */
   0x049,  /* 0xcf ..  */
   0x095,  /* 0xd0 ..  */
   0x061,  /* 0xd1 ..  */
   0x096,  /* 0xd2 ..  */
   0x097,  /* 0xd3 ..  */
   0x098,  /* 0xd4 ..  */
   0x099,  /* 0xd5 ..  */
   0x060,  /* 0xd6 ..  */
   0x0de,  /* 0xd7 ..  */
   0x00f,  /* 0xd8 ..  */
   0x09a,  /* 0xd9 ..  */
   0x09b,  /* 0xda ..  */
   0x059,  /* 0xdb ..  */
   0x062,  /* 0xdc ..  */
   0x0af,  /* 0xdd ..  */
   NOCHAR_OLD,  /* 0xde ..  */
   0x022,  /* 0xdf ..  */
   0x083,  /* 0xe0 ..  */
   0x09c,  /* 0xe1 ..  */
   0x09d,  /* 0xe2 ..  */
   0x09e,  /* 0xe3 ..  */
   0x07f,  /* 0xe4 ..  */
   0x09d,  /* 0xe5 ..  */
   NOCHAR_OLD,  /* 0xe6 ..  */
   0x084,  /* 0xe7 ..  */
   0x008,  /* 0xe8 ..  */
   0x009,  /* 0xe9 ..  */
   0x09f,  /* 0xea ..  */
   0x0a0,  /* 0xeb ..  */
   0x06d,  /* 0xec ..  */
   0x0a1,  /* 0xed ..  */
   0x0a2,  /* 0xee ..  */
   0x0a3,  /* 0xef ..  */
   NOCHAR_OLD,  /* 0xf0 ..  */
   0x081,  /* 0xf1 ..  */
   0x096,  /* 0xf2 ..  */
   0x0a4,  /* 0xf3 ..  */
   0x0a5,  /* 0xf4 ..  */
   0x0a6,  /* 0xf5 ..  */
   0x080,  /* 0xf6 ..  */
   NOCHAR_OLD,  /* 0xf7 ..  */
   0x010,  /* 0xf8 ..  */
   0x00a,  /* 0xf9 ..  */
   0x0a7,  /* 0xfa ..  */
   0x079,  /* 0xfb ..  */
   0x082,  /* 0xfc ..  */
   0x0af,  /* 0xfd ..  */
   NOCHAR_OLD,  /* 0xfe ..  */
   0x07d,  /* 0xff ..  */
};

/* second table -- substitute */
const unsigned char 
      lcd_player_extended_lcd_to_rocklatin1[NO_EXTENDED_LCD_CHARS] =
{
/* 00 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 01 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 02 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 03 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 04 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 05 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 06 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 07 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 08 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 09 */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0a */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0b */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0c */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0d */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0e */ NOCHAR_NEW,  /* 0-16 user defined */
/* 0f */ NOCHAR_NEW,  /* 0-16 user defined */
/* 10 */ NOCHAR_NEW,  /* reserved */
/* 11 */ NOCHAR_NEW,  /* reserved */
/* 12 */ NOCHAR_NEW,  /* reserved */
/* 13 */ NOCHAR_NEW,  /* reserved */
/* 14 */ NOCHAR_NEW,  /* reserved */
/* 15 */ NOCHAR_NEW,  /* reserved */
/* 16 */ 0x91,  /* bookmark icon */
/* 17 */ 0x29,  /* plugin icon */
/* 18 */ 0x93, /* folder icon */
/* 19 */ 'x', /* MOD/AJZ icon */
/* 1a */ '+', /* language icon */
/* 1b */ 0x94, /* note icon */
/* 1c */ 0x91, /* WPS icon */
/* 1d */ 0x95, /* playlist icon */
/* 1e */ 0x95, /* text file icon */
/* 1f */ 0x95, /* config file icon */
/* 20 */  '/', /* substitute char for old lcd \ */
/* 21 */  '\'', /* substitute char for old lcd ` */
/* 22 */  '!', /* substitute char for old lcd | */
/* 23 */  '-', /* substitute char for old lcd ~ */
/* 24 */  '.', /* substitute char for new lcd (three dots) */
/* 25 */  'z', /* substitue char for new lcd (0x0bd) 'z' with upside down ^ */
/* 26 */  'L', /* substitue char for new lcd (0x005)  */
/* 27 */  NOCHAR_NEW, /* empty */
/* 28 */  '-', /* substitue char for new lcd (0x0ee)  */
/* 29 */  '?', /* substitue char for new lcd (0x064)  */
/* 2a */  'A', /* substitue char for new lcd (0x08c)  */
/* 2b */  'A', /* substitue char for new lcd (0x08d)  */
/* 2c */  'A', /* substitue char for new lcd (0x08e)  */
/* 2d */  'A', /* substitue char for new lcd (0x08e)  */
/* 2e */  'A', /* substitue char for new lcd (0x05f)  */
/* 2f */  'A', /* substitue char for new lcd (0x012)  */
/* 30 */  'A', /* substitue char for new lcd (0x020)  */
/* 31 */  'C', /* substitue char for new lcd (0x00d)  */
/* 32 */  'E', /* substitue char for new lcd (0x090)  */
/* 33 */  'E', /* substitue char for new lcd (0x023)  */
/* 34 */  'E', /* substitue char for new lcd (0x091)  */
/* 35 */  'E', /* substitue char for new lcd (0x092)  */
/* 36 */  'I', /* substitue char for new lcd (0x093)  */
/* 37 */  'I', /* substitue char for new lcd (0x094)  */
/* 38 */  'D', /* substitue char for new lcd (0x095)  */
/* 39 */  'N', /* substitue char for new lcd (0x061)  */
/* 3a */  'O', /* substitue char for new lcd (0x096)  */
/* 3b */  'O', /* substitue char for new lcd (0x097)  */
/* 3c */  'O', /* substitue char for new lcd (0x098)  */
/* 3d */  'O', /* substitue char for new lcd (0x099)  */
/* 3e */  'O', /* substitue char for new lcd (0x060)  */
/* 3f */  'x', /* substitue char for new lcd (0x0de)  */
/* 40 */  '0', /* substitue char for new lcd (0x00f)  */
/* 41 */  'U', /* substitue char for new lcd (0x09a)  */
/* 42 */  'U', /* substitue char for new lcd (0x09b)  */
/* 43 */  'U', /* substitue char for new lcd (0x062)  */
/* 44 */  'B', /* substitue char for new lcd (0x022)  */
/* 45 */  'a', /* substitue char for new lcd (0x083)  */
/* 46 */  'a', /* substitue char for new lcd (0x09c)  */
/* 47 */  'a', /* substitue char for new lcd (0x09d)  */
/* 48 */  'a', /* substitue char for new lcd (0x09e)  */
/* 49 */  'a', /* substitue char for new lcd (0x07f)  */
/* 4a */  'a', /* substitue char for new lcd (0x09d)  */
/* 4b */  'c', /* substitue char for new lcd (0x084)  */
/* 4c */  'e', /* substitue char for new lcd (0x008)  */
/* 4d */  'e', /* substitue char for new lcd (0x009)  */
/* 4e */  'e', /* substitue char for new lcd (0x09f)  */
/* 4f */  'e', /* substitue char for new lcd (0x0a0)  */
/* 50 */  'i', /* substitue char for new lcd (0x0a1)  */
/* 51 */  'i', /* substitue char for new lcd (0x0a2)  */
/* 52 */  'i', /* substitue char for new lcd (0x0a3)  */
/* 53 */  'n', /* substitue char for new lcd (0x081)  */
/* 54 */  'o', /* substitue char for new lcd (0x0a4)  */
/* 55 */  'o', /* substitue char for new lcd (0x0a5)  */
/* 56 */  'o', /* substitue char for new lcd (0x0a6)  */
/* 57 */  'o', /* substitue char for new lcd (0x080)  */
/* 58 */  'o', /* substitue char for new lcd (0x010)  */
/* 59 */  'u', /* substitue char for new lcd (0x00a)  */
/* 5a */  'u', /* substitue char for new lcd (0x0a7)  */
/* 5b */  'u', /* substitue char for new lcd (0x082)  */
/* 5c */  'y', /* substitue char for new lcd (0x0af)  */
/* 5d */ '?', /* unknown icon */

};

unsigned char extended_font_player[NO_EXTENDED_LCD_CHARS][8] = {
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 00 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 01 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 02 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 03 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 04 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 05 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 06 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 07 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 08 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 09 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0a */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0b */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0c */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0d */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0e */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 0f */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 10 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 11 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 12 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 13 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 14 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 15 */
  { 0x00, 0x03, 0x07, 0x0e, 0x1c, 0x08, 0x00, 0x00}, /* 16 Bookmark icon */
  { 0x04, 0x1e, 0x07, 0x1f, 0x05, 0x01, 0x06, 0x00}, /* 17 Plugin file icon */
  { 0x0c, 0x13, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00}, /* 18 Folder icon */
  { 0x1f, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x1f, 0x00}, /* 19 MOD/AJZ icon */
  { 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00}, /* 1a Language icon */
  { 0x03, 0x05, 0x09, 0x09, 0x0b, 0x1b, 0x18, 0x00}, /* 1b note icon */
  { 0x01, 0x01, 0x02, 0x02, 0x14, 0x0c, 0x04, 0x00}, /* 1c WPS icon */
  { 0x17, 0x00, 0x17, 0x00, 0x17, 0x00, 0x17, 0x00}, /* 1d Playlist icon */
  { 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00}, /* 1e Text file icon */
  { 0x0b, 0x10, 0x0b, 0x00, 0x1f, 0x00, 0x1f, 0x00}, /* 1f Config file icon */

  /* Unprioritized chars follows below, least prioritized char last */
  { 0x00, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00}, /* 20 '\' new lcd 0x12 */
  { 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 21 '`' new lcd 0x60 */ 
  { 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00}, /* 22 '|' new lcd 0x7c */
  { 0x00, 0x00, 0x08, 0x15, 0x02, 0x00, 0x00, 0x00}, /* 23 '~' new lcd 0xf0 */
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00}, /* 24 old lcd 0x85 */
  { 0x0a, 0x04, 0x1f, 0x02, 0x04, 0x08, 0x1f, 0x00}, /* 25 old lcd 0xbd */
  { 0x06, 0x09, 0x08, 0x1e, 0x08, 0x08, 0x1f, 0x00}, /* 26 old lcd 0x05 */
  { 0x0e, 0x10, 0x0e, 0x11, 0x0e, 0x01, 0x0e, 0x00}, /* 27 old lcd 0x63 */
  { 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* 28 old lcd 0xee */
  { 0x04, 0x00, 0x04, 0x08, 0x10, 0x11, 0x0e, 0x00}, /* 29 old lcd 0x64 */
  { 0x08, 0x04, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00}, /* 2a old lcd 0x8c */
  { 0x02, 0x04, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00}, /* 2b old lcd 0x8d */
  { 0x04, 0x0a, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00}, /* 2c old lcd 0x8e */
  { 0x0d, 0x12, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00}, /* 2d old lcd 0x8f */
  { 0x0a, 0x00, 0x04, 0x0a, 0x11, 0x1f, 0x11, 0x00}, /* 2e old lcd 0x5f */
  { 0x04, 0x0a, 0x04, 0x0e, 0x11, 0x1f, 0x11, 0x00}, /* 2f old lcd 0x12 */
  { 0x0f, 0x14, 0x14, 0x1f, 0x14, 0x14, 0x17, 0x00}, /* 30 old lcd 0x20 */
  { 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x02, 0x0e, 0x00}, /* 31 old lcd 0x0d */
  { 0x08, 0x04, 0x1f, 0x10, 0x1e, 0x10, 0x1f, 0x00}, /* 32 old lcd 0x90 */
  { 0x02, 0x04, 0x1f, 0x10, 0x1c, 0x10, 0x1f, 0x00}, /* 33 old lcd 0x23 */
  { 0x04, 0x0a, 0x1f, 0x10, 0x1c, 0x10, 0x1f, 0x00}, /* 34 old lcd 0x91 */
  { 0x0a, 0x00, 0x1f, 0x10, 0x1c, 0x10, 0x1f, 0x00}, /* 35 old lcd 0x92 */
  { 0x08, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00}, /* 36 old lcd 0x93 */
  { 0x02, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00}, /* 37 old lcd 0x94 */
  { 0x0c, 0x0a, 0x09, 0x1d, 0x09, 0x0a, 0x0c, 0x00}, /* 38 old lcd 0x95 */
  { 0x0d, 0x12, 0x00, 0x19, 0x15, 0x13, 0x11, 0x00}, /* 39 old lcd 0x61 */
  { 0x08, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 3a old lcd 0x96 */
  { 0x02, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 3b old lcd 0x97 */
  { 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 3c old lcd 0x98 */
  { 0x0d, 0x12, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 3d old lcd 0x99 */
  { 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 3e old lcd 0x60 */
  { 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x00}, /* 3f old lcd 0xde */
  { 0x01, 0x0e, 0x13, 0x15, 0x19, 0x0e, 0x10, 0x00}, /* 40 old lcd 0x0f */
  { 0x08, 0x04, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 41 old lcd 0x9a */
  { 0x02, 0x04, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 42 old lcd 0x9b */
  { 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00}, /* 43 old lcd 0x62 */
  { 0x0c, 0x12, 0x16, 0x11, 0x11, 0x16, 0x10, 0x00}, /* 44 old lcd 0x22 */
  { 0x08, 0x04, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 45 old lcd 0x83 */
  { 0x02, 0x04, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 46 old lcd 0x9c */
  { 0x04, 0x0a, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 47 old lcd 0x9d */
  { 0x0d, 0x12, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 48 old lcd 0x9e */
  { 0x0a, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 49 old lcd 0x7f */
  { 0x04, 0x0a, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00}, /* 4a old lcd 0x9d */
  { 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x02, 0x04, 0x00}, /* 4b old lcd 0x84 */
  { 0x08, 0x04, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0x00}, /* 4c old lcd 0x08 */
  { 0x02, 0x04, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0x00}, /* 4d old lcd 0x09 */
  { 0x04, 0x0a, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0x00}, /* 4e old lcd 0x9f */
  { 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0x00}, /* 4f old lcd 0xa0 */
  { 0x02, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00}, /* 50 old lcd 0xa1 */
  { 0x04, 0x0a, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00}, /* 51 old lcd 0xa2 */
  { 0x0a, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x0e, 0x00}, /* 52 old lcd 0xa3 */
  { 0x0d, 0x12, 0x00, 0x16, 0x19, 0x11, 0x11, 0x00}, /* 53 old lcd 0x81 */
  { 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00}, /* 54 old lcd 0xa4 */
  { 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00}, /* 55 old lcd 0xa5 */
  { 0x0d, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00}, /* 56 old lcd 0xa6 */
  { 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00}, /* 57 old lcd 0x80 */
  { 0x00, 0x02, 0x0e, 0x15, 0x15, 0x0e, 0x08, 0x00}, /* 58 old lcd 0x10 */
  { 0x08, 0x04, 0x00, 0x11, 0x11, 0x13, 0x0d, 0x00}, /* 59 old lcd 0x0a */
  { 0x02, 0x04, 0x00, 0x11, 0x11, 0x13, 0x0d, 0x00}, /* 5a old lcd 0xa7 */
  { 0x00, 0x0a, 0x00, 0x11, 0x11, 0x13, 0x0d, 0x00}, /* 5b old lcd 0x82 */
  { 0x02, 0x04, 0x11, 0x11, 0x0f, 0x01, 0x0e, 0x00}, /* 5c old lcd 0xaf */
  { 0x0c, 0x12, 0x12, 0x08, 0x08, 0x00, 0x08, 0x00}, /* 5d Unknown icon */
};

#endif /* HAVE_LCD_CHARCELLS */
