/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id: snake2.c,v 1.17 2005/08/13 20:41:30 bagder Exp $
 *
 * Copyright (C) 2003 Mat Holton
 *
 * All files in this archive are subject to the GNU General Public License.
 * See the file COPYING in the source tree root for full license agreement.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

/*
Snake2!

Board consists of a WIDTHxHEIGHT grid. If board element is 0 then nothing is 
there otherwise it is part of the snake or a wall.

Head and Tail are stored

*/

#include "plugin.h"
#ifdef HAVE_LCD_BITMAP

#define WIDTH  28
#define HEIGHT 16

#if LCD_WIDTH >= 160 && LCD_HEIGHT >= 128
    #define MULTIPLIER 5 /*Modifier for porting on other screens*/
    #define MODIFIER_1 5
    #define MODIFIER_2 3
    #define CENTER_X 10
    #define CENTER_Y 38
    #define BMPHEIGHT_snakebmp 128
    #define BMPWIDTH_snakebmp 160
    #define BMPHEIGHT_snakeupbmp 36
    #define BMPWIDTH_snakeupbmp 160
#else
    #define MULTIPLIER 4
    #define MODIFIER_1 4
    #define MODIFIER_2 2
    #define CENTER_X 0
    #define CENTER_Y 0

#endif


 

/* variable button definitions */
#if CONFIG_KEYPAD == RECORDER_PAD
#define SNAKE2_QUIT BUTTON_OFF
#define SNAKE2_LEVEL_UP BUTTON_UP
#define SNAKE2_LEVEL_UP2 BUTTON_RIGHT
#define SNAKE2_LEVEL_DOWN BUTTON_DOWN
#define SNAKE2_LEVEL_DOWN2 BUTTON_LEFT
#define SNAKE2_SELECT_MAZE BUTTON_F1
#define SNAKE2_SELECT_TYPE BUTTON_F3
#define SNAKE2_PLAYPAUSE BUTTON_PLAY

#elif CONFIG_KEYPAD == ONDIO_PAD
#define SNAKE2_QUIT BUTTON_OFF
#define SNAKE2_LEVEL_UP BUTTON_UP
#define SNAKE2_LEVEL_DOWN BUTTON_DOWN
#define SNAKE2_SELECT_MAZE BUTTON_LEFT
#define SNAKE2_SELECT_TYPE BUTTON_RIGHT
#define SNAKE2_PLAYPAUSE BUTTON_MENU

#elif (CONFIG_KEYPAD == IRIVER_H100_PAD) || \
      (CONFIG_KEYPAD == IRIVER_H300_PAD)
#define SNAKE2_QUIT BUTTON_OFF
#define SNAKE2_LEVEL_UP BUTTON_UP
#define SNAKE2_LEVEL_UP2 BUTTON_RIGHT
#define SNAKE2_LEVEL_DOWN BUTTON_DOWN
#define SNAKE2_LEVEL_DOWN2 BUTTON_LEFT
#define SNAKE2_SELECT_MAZE BUTTON_REC
#define SNAKE2_SELECT_TYPE BUTTON_MODE
#define SNAKE2_PLAYPAUSE BUTTON_ON
#else
#error "lacks keymapping"
#endif

static int max_levels = 0;
static char (*level_cache)[HEIGHT][WIDTH];

/*Board itself - 2D int array*/
static int board[WIDTH][HEIGHT];
/*
  Buffer for sorting movement (in case user presses two movements during a 
  single frame
*/
static int ardirectionbuffer[2];
static unsigned int score, hiscore = 0;
static int applex;
static int appley;
static int strwdt,strhgt; /*used for string width, height for orientation purposes*/
static int dir;
static int frames;
static int apple;
static int level = 4, speed = 5,dead = 0, quit = 0;
static int sillydir = 0, num_levels = 0; 
static int level_from_file = 1;
static struct plugin_api* rb;
static int headx, heady, tailx, taily, applecountdown = 5;
static int game_type = 0;
static int num_apples_to_get=1;
static int num_apples_to_got=0;
static int game_b_level=1;
static int applecount=0;
static char phscore[30];


#ifdef BMPHEIGHT_snakebmp
const unsigned char snakebmp[] = {
0x00, 0x00, 0x00, 0xe0, 0x20, 0xa0, 0xa0, 0x00, 0xe0, 0xa0, 0xa0, 0xe0, 0x00,
0xe0, 0x40, 0x80, 0x40, 0xe0, 0x00, 0xe0, 0xa0, 0xa0, 0xa0, 0x00, 0x00, 0xf0,
0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0xf0, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x80,
0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x80, 0x80,
0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02,
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
0x02, 0x04, 0x08, 0xf0, 0x00, 0x00, 0xe0, 0x40, 0x80, 0x40, 0xe0, 0x00, 0xe0,
0xa0, 0xa0, 0xe0, 0x00, 0x20, 0xa0, 0xa0, 0x60, 0x00, 0xe0, 0xa0, 0xa0, 0xa0,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x03, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0xc3, 0x22, 0x22, 0x22, 0xc0, 0x00, 0x07,
0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x27, 0x4c, 0x4c, 0x79, 0x3b,
0x00, 0x40, 0x7f, 0x47, 0x0e, 0x1c, 0x38, 0x7f, 0x00, 0x40, 0x70, 0x5c, 0x13,
0x13, 0x5f, 0x7c, 0x70, 0x40, 0x40, 0x7f, 0x7f, 0x48, 0x0c, 0x3e, 0x79, 0x60,
0x40, 0x40, 0x7f, 0x7f, 0x44, 0x4e, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
0x20, 0x10, 0x08, 0x07, 0x00, 0xe0, 0x13, 0x10, 0x10, 0xe0, 0x03, 0x00, 0x03,
0x00, 0x00, 0x03, 0x00, 0x03, 0x02, 0x02, 0x02, 0x00, 0x03, 0x02, 0x02, 0x02,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x98, 0xa4, 0xa4, 0x98, 0x80, 0x81, 0x02, 0x82, 0x82, 0x01, 0x00, 0x00,
0x00, 0x17, 0x15, 0x15, 0x1d, 0x80, 0x5f, 0x45, 0x45, 0x42, 0x40, 0x5f, 0x55,
0x55, 0x55, 0x40, 0x5f, 0x55, 0x55, 0x55, 0x40, 0x5f, 0x51, 0x51, 0x4e, 0x40,
0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0, 0xf0, 0x10,
0x00, 0x10, 0xf0, 0xf0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x1f, 0x80, 0x51,
0x5f, 0x51, 0x44, 0x44, 0x44, 0x40, 0x57, 0x55, 0x55, 0x5d, 0x40, 0x5f, 0x51,
0x51, 0x51, 0x40, 0x5f, 0x51, 0x51, 0x5f, 0x40, 0x5f, 0x45, 0x4d, 0x92, 0x00,
0x1f, 0x15, 0x15, 0x15, 0x00, 0x00, 0x01, 0x81, 0x81, 0x00, 0x98, 0xa4, 0xa4,
0x98, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x30, 0xf8, 0x8c, 0x1a, 0x7f, 0xc0,
0x90, 0x60, 0xc7, 0xce, 0x4c, 0x8f, 0x00, 0x47, 0x0e, 0x1e, 0x57, 0x90, 0xe0,
0x00, 0x10, 0x28, 0xc6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0f, 0x0f, 0x08,
0x00, 0x08, 0x0f, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
0xc6, 0x28, 0x10, 0x00, 0xe0, 0x90, 0x57, 0x1e, 0x0e, 0x47, 0x00, 0x8f, 0x4c,
0xce, 0xc7, 0x60, 0x90, 0xc0, 0x7f, 0x1a, 0x8c, 0xf8, 0x30, 0x20, 0xc0, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x80, 0xf0, 0x9c, 0x16, 0x57, 0x4d, 0xe9, 0xa1, 0xf5, 0xfc, 0x36, 0x3b, 0x39,
0x37, 0x33, 0x31, 0x30, 0x31, 0x32, 0x35, 0x35, 0x35, 0x35, 0x33, 0x30, 0x30,
0x30, 0x30, 0x30, 0x30, 0x31, 0x32, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
0x34, 0x34, 0x32, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x31, 0x32, 0x34,
0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x32, 0x31,
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x35, 0x35, 0x35, 0x35, 0x32, 0x31,
0x30, 0x31, 0x33, 0x37, 0x39, 0x3b, 0x36, 0xfc, 0xf5, 0xa1, 0xe9, 0x4d, 0x57,
0x16, 0x9c, 0xf0, 0x80, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0xff, 0x88, 0xad, 0x25, 0x77, 0x52, 0xda, 0x88, 0xff, 0xff, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0x88, 0xda, 0x52, 0x77,
0x25, 0xad, 0x88, 0xff, 
0x0f, 0x1c, 0x39, 0x6d, 0x77, 0xda, 0x8c, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3,
0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e,
0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e,
0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e,
0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3,
0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8,
0x8e, 0xb8, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8,
0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3,
0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e,
0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e,
0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e,
0xe3, 0xb8, 0x8e, 0xb8, 0xe3, 0x8e, 0xb8, 0x8e, 0xe3, 0xb8, 0x8c, 0x5a, 0x77,
0x6d, 0x39, 0x1c, 0x0f, 

};
#endif

#ifdef BMPHEIGHT_snakeupbmp
const unsigned char snakeupbmp[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00,
0x80, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x80,
0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xc0, 0x40, 0x40, 0xc0, 0x00, 0xc0, 0x40, 0x40, 0x80, 0x00, 0xc0, 0x40, 0x40,
0x80, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x00, 0xc0,
0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x27, 0x4c, 0x4c, 0x79,
0x3b, 0x00, 0x40, 0x7f, 0x47, 0x0e, 0x1c, 0x38, 0x7f, 0x00, 0x40, 0x70, 0x5c,
0x13, 0x13, 0x5f, 0x7c, 0x70, 0x40, 0x40, 0x7f, 0x7f, 0x48, 0x0c, 0x3e, 0x79,
0x60, 0x40, 0x40, 0x7f, 0x7f, 0x44, 0x4e, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x00, 0xc0,
0x40, 0x40, 0xc0, 0x00, 0xc0, 0x40, 0x40, 0x80, 0x00, 0xc0, 0x40, 0x40, 0x40,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00,
0x07, 0x01, 0x01, 0x07, 0x00, 0x87, 0x41, 0x41, 0x40, 0x40, 0x47, 0x41, 0x41,
0x40, 0x40, 0x47, 0x44, 0x44, 0x44, 0x40, 0x47, 0x45, 0x45, 0x45, 0x40, 0x45,
0x45, 0x45, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0, 0xf0,
0x10, 0x00, 0x10, 0xf0, 0xf0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40,
0x40, 0x40, 0x45, 0x45, 0x45, 0x47, 0x40, 0x47, 0x44, 0x44, 0x44, 0x40, 0x47,
0x44, 0x44, 0x47, 0x40, 0x47, 0x41, 0x43, 0x44, 0x40, 0x47, 0x45, 0x85, 0x05,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x30, 0xf8, 0x8c, 0x1a, 0x7f, 0xc0,
0x90, 0x60, 0xc7, 0xce, 0x4c, 0x8f, 0x00, 0x47, 0x0e, 0x1e, 0x57, 0x90, 0xe0,
0x00, 0x10, 0x28, 0xc6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0f, 0x0f,
0x08, 0x00, 0x08, 0x0f, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
0xc6, 0x28, 0x10, 0x00, 0xe0, 0x90, 0x57, 0x1e, 0x0e, 0x47, 0x00, 0x8f, 0x4c,
0xce, 0xc7, 0x60, 0x90, 0xc0, 0x7f, 0x1a, 0x8c, 0xf8, 0x30, 0x20, 0xc0, 0x00,
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x0c, 0x06, 0x07, 0x0d, 0x09, 0x01, 0x05, 0x0c, 0x06, 0x0b, 0x09,
0x07, 0x03, 0x01, 0x00, 0x01, 0x02, 0x05, 0x05, 0x05, 0x05, 0x03, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x01,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x05, 0x05, 0x05, 0x02, 0x01,
0x00, 0x01, 0x03, 0x07, 0x09, 0x0b, 0x06, 0x0c, 0x05, 0x01, 0x09, 0x0d, 0x07,
0x06, 0x0c, 0x00, 0x00, 

};
#endif

#define NORTH       1   
#define EAST        2   
#define SOUTH       4   
#define WEST        8   
#define HEAD        16  

#define EAST_NORTH  32
#define EAST_SOUTH  64
#define WEST_NORTH  128
#define WEST_SOUTH  256

#define NORTH_EAST  512
#define NORTH_WEST  1024
#define SOUTH_EAST  2048
#define SOUTH_WEST  4096

#define LEVELS_FILE  PLUGIN_DIR "/snake2.levels"
#define HISCORE_FILE PLUGIN_DIR "/snake2.hs"

int load_all_levels(void)
{
    int linecnt = 0;
    int fd;
    int size;
    char buf[64]; /* Larger than WIDTH, to allow for whitespace after the
                     lines */

    /* Init the level_cache pointer and
       calculate how many levels that will fit */
    level_cache = rb->plugin_get_buffer(&size);
    max_levels = size / (HEIGHT*WIDTH);

    num_levels = 0;
    
    /* open file */
    if ((fd = rb->open(LEVELS_FILE, O_RDONLY)) < 0)
    {
        return -1;
    }

    while(rb->read_line(fd, buf, 64))
    {
        if(rb->strlen(buf) == 0) /* Separator? */
        {
            num_levels++;
            if(num_levels > max_levels)
            {
                rb->splash(HZ, true, "Too many levels in file");
                break;
            }
            continue;
        }

        rb->memcpy(level_cache[num_levels][linecnt], buf, WIDTH);
        linecnt++;
        if(linecnt == HEIGHT)
        {
            linecnt = 0;
        }
    }

    rb->close(fd);
    return 0;
}

/*Hi-Score reading and writing to file "/.rockbox/snake2.levels" function */
void iohiscore(void)
{
    int fd;
    unsigned int compare;

    /* clear the buffer we're about to load the highscore data into */
    rb->memset(phscore, 0, sizeof(phscore));

    fd = rb->open(HISCORE_FILE,O_RDWR | O_CREAT);

    /* highscore used to %d, is now %d\n
       Deal with no file or bad file */
    rb->read(fd,phscore, sizeof(phscore));

    compare = rb->atoi(phscore);

    if(hiscore > compare){
        rb->lseek(fd,0,SEEK_SET);
        rb->fdprintf(fd, "%d\n", hiscore);
    }
    else
        hiscore = compare;   
    
    rb->close(fd);

}

/*
** Completely clear the board of walls and/or snake     */

void clear_board( void)
{
    int x,y;

    for (x = 0; x < WIDTH; x++) 
    {
        for (y = 0; y < HEIGHT; y++) 
        {
            board[x][y] = 0;
        }
    }
}

int load_level( int level_number )
{
    int x,y;
    clear_board();
    for(y = 0;y < HEIGHT;y++)
    {
        for(x = 0;x < WIDTH;x++)
        {
            switch(level_cache[level_number][y][x])
            {
                case '|':
                    board[x][y] = NORTH;
                    break;

                case '-':
                    board[x][y] = EAST;
                    break;

                case '+':
                    board[x][y] = HEAD;
                    break;
            }
        }
    }
    return 1;
}

/*
** Gets the currently chosen direction from the first place
** in the direction buffer. If there is something in the
** next part of the buffer then that is moved to the first place
*/
void get_direction( void )
{
    /*if 1st place is empty*/
    if(ardirectionbuffer[0] != -1)
    {
        /*return this direction*/
        dir = ardirectionbuffer[0];
        ardirectionbuffer[0]=-1;
        /*now see if one needs moving:*/
        if(ardirectionbuffer[1] != -1)
        {
            /*there's a move waiting to be done
              so move it into the space:*/
            ardirectionbuffer[0] = ardirectionbuffer[1];
            ardirectionbuffer[1] = -1;
        }
    }
}

/*
** Sets the direction 
*/
void set_direction(int newdir)
{
    if(ardirectionbuffer[0] != newdir)
    {
        /*if 1st place is empty*/
        if(ardirectionbuffer[0] == -1)
        {
            /*use 1st space:*/
            ardirectionbuffer[0] = newdir;
        }
        else
        {
            /*use 2nd space:*/
            if(ardirectionbuffer[0] != newdir) ardirectionbuffer[1] = newdir;
        }

        if(frames < 0) ardirectionbuffer[0] = newdir;
    }
}

void new_level(int level)
{
    load_level(level);

    ardirectionbuffer[0] = -1;
    ardirectionbuffer[1] = -1;
    dir   = EAST;
    headx = WIDTH/2;
    heady = HEIGHT/2;
    tailx = headx - 4;
    taily = heady;
    applecountdown = 0;
    /*Create a small snake to start off with*/      
    board[headx][heady]   = dir;
    board[headx-1][heady] = dir;
    board[headx-2][heady] = dir;
    board[headx-3][heady] = dir;
    board[headx-4][heady] = dir;
    num_apples_to_got=0;
}

void init_snake(void)
{
    num_apples_to_get=1;
    if(game_type == 1)
       level_from_file = 1;
    game_b_level=1;
    new_level(level_from_file);
}

/*
** Draws the apple. If it doesn't exist then
** a new one get's created.
*/
void draw_apple( void )
{
    int x,y;

#if LCD_WIDTH >= 160 && LCD_HEIGHT >= 128
    char pscore[5], counter[4];

    rb->lcd_set_drawmode(DRMODE_FG);
    rb->lcd_mono_bitmap(snakebmp,0,0,BMPWIDTH_snakebmp,BMPHEIGHT_snakebmp);
    rb->lcd_set_drawmode(DRMODE_SOLID|DRMODE_INVERSEVID);
    rb->lcd_fillrect(0,0,BMPWIDTH_snakeupbmp,BMPHEIGHT_snakeupbmp);
    rb->lcd_set_drawmode(DRMODE_FG);
    rb->lcd_mono_bitmap(snakeupbmp,0,0,BMPWIDTH_snakeupbmp,BMPHEIGHT_snakeupbmp);
    rb->lcd_set_drawmode(DRMODE_SOLID);

    rb->snprintf(counter,sizeof(counter),"%d",applecount);
    rb->lcd_getstringsize(counter,&strwdt,&strhgt);
    rb->lcd_putsxy(42-strwdt/2,25,counter);

    rb->snprintf(pscore,sizeof(pscore),"%d",score);
    rb->lcd_getstringsize(pscore,&strwdt,&strhgt);
    rb->lcd_putsxy(116-strwdt/2,25,pscore);
#endif

    if (!apple)
    {
          do
          {
            x = (rb->rand() % (WIDTH-1))+1;
            y = (rb->rand() % (HEIGHT-1))+1;
          } while (board[x][y]);
          apple=1;
          board[x][y]=-1;
          applex = x;appley = y;
    }
    rb->lcd_fillrect((CENTER_X+applex*MULTIPLIER)+1,CENTER_Y+appley*MULTIPLIER,MODIFIER_2,MODIFIER_1);
    rb->lcd_fillrect(CENTER_X+applex*MULTIPLIER,(CENTER_Y+appley*MULTIPLIER)+1,MODIFIER_1,MODIFIER_2);
}

/*
    * x x *
    * x x *
    * x x *
    * x x *
*/
void draw_vertical_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+1,CENTER_Y+y*MULTIPLIER,MODIFIER_2,MODIFIER_1);
}

/*
    * * * *
    X X X X
    X X X X
    * * * *
*/
void draw_horizontal_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,CENTER_Y+y*MULTIPLIER+1,MODIFIER_1,MODIFIER_2);
}

/*
    * * * *
    * * X X
    * X X X
    * X X *
*/
void draw_n_to_e_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+1,CENTER_Y+y*MULTIPLIER+2,MODIFIER_2,MODIFIER_2);
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+2,CENTER_Y+y*MULTIPLIER+1,MODIFIER_2,MODIFIER_2);
}

/*
   * * * *
   * * X X
   * X X X
   * X X *
*/
void draw_w_to_s_bit(int x, int y)
{
    draw_n_to_e_bit(x,y);
}

/*
   * * * *
   X X * *
   X X X *
   * X X *
*/
void draw_n_to_w_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,CENTER_Y+y*MULTIPLIER+1,MODIFIER_2,MODIFIER_2);
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+1,CENTER_Y+y*MULTIPLIER+2,MODIFIER_2,MODIFIER_2);
}

/*
   * * * *
   X X * *
   X X X *
   * X X *
*/
void draw_e_to_s_bit(int x, int y)
{
    draw_n_to_w_bit(x, y);
}

/*
   * X X *
   * X X X
   * * X X
   * * * *
*/
void draw_s_to_e_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+1,CENTER_Y+y*MULTIPLIER,MODIFIER_2,MODIFIER_2);
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+2,CENTER_Y+y*MULTIPLIER+1,MODIFIER_2,MODIFIER_2);
}

/*
   * X X *
   * X X X
   * * X X
   * * * *
*/
void draw_w_to_n_bit(int x, int y)
{
    draw_s_to_e_bit(x,y);
}

/*
   * X X *
   X X X *
   X X * *
   * * * *
*/
void draw_e_to_n_bit(int x, int y)
{
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER+1,CENTER_Y+y*MULTIPLIER,MODIFIER_2,MODIFIER_2);
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,CENTER_Y+y*MULTIPLIER+1,MODIFIER_2,MODIFIER_2);
}

/*
   * X X *
   X X X *
   X X * *
   * * * *
*/
void draw_s_to_w_bit(int x, int y)
{
    draw_e_to_n_bit(x, y);
}

/*
** Draws a wall/obsticals
*/
void draw_boundary ( void )
{
    int x, y;
    
    /*TODO: Load levels from file!*/

    /*top and bottom line*/
    for(x=0; x < WIDTH; x++)
    {
        board[x][0] = EAST;
        board[x][HEIGHT-1] = WEST;
    }
    
    /*left and right lines*/
    for(y=0; y < HEIGHT; y++)
    {
        board[0][y] = NORTH;
        board[WIDTH-1][y] = SOUTH;
    }

    /*corners:*/
    board[0][0]              = NORTH_EAST;
    board[WIDTH-1][0]        = EAST_SOUTH;
    board[0][HEIGHT-1]       = SOUTH_EAST;
    board[WIDTH-1][HEIGHT-1] = EAST_NORTH;
}

/*
** Redraw the entire board
*/
void redraw (void)
{
    int x,y;
    rb->lcd_clear_display();
   
    for (x = 0; x < WIDTH; x++) 
    {
        for (y = 0; y < HEIGHT; y++) 
        {
            switch (board[x][y]) 
            {
                case -1:
                    rb->lcd_fillrect((CENTER_X+x*MULTIPLIER)+1,CENTER_Y+y*MULTIPLIER,MODIFIER_2,MODIFIER_1);
                    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,(CENTER_Y+y*MULTIPLIER)+1,MODIFIER_1,MODIFIER_2);
                    break;
                case 0:
                    break;
                
                case NORTH:
                case SOUTH:
                    draw_vertical_bit(x,y);
                    break;
                
                case EAST:
                case WEST:
                    draw_horizontal_bit(x,y);
                    break;
                    
                default:
                    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,CENTER_Y+y*MULTIPLIER,MODIFIER_1,MODIFIER_1);
                    break;
            }
        }
    }
    rb->lcd_update();

}

/*
** Draws the snake bit described by nCurrentBit at position x/y
** deciding whether it's a corner bit by examing the nPrevious bit
*/
void draw_snake_bit(int currentbit, int previousbit, int x, int y)
{
    rb->lcd_set_drawmode(DRMODE_SOLID|DRMODE_INVERSEVID);
    rb->lcd_fillrect(CENTER_X+x*MULTIPLIER,CENTER_Y+y*MULTIPLIER,MODIFIER_1,MODIFIER_1);
    rb->lcd_set_drawmode(DRMODE_SOLID);

    switch(currentbit)
    {
        case(NORTH):
            switch(previousbit)
            {
                case(SOUTH):
                case(NORTH):
                    draw_vertical_bit(x,y);
                break;
                
                case(EAST):
                    draw_e_to_n_bit(x,y);
                break;

                case(WEST):
                    draw_w_to_n_bit(x,y);
                break;
            }
        break;

        case(EAST):
            switch(previousbit)
            {
                case(WEST):
                case(EAST):
                    draw_horizontal_bit(x,y);
                break;  
                
                case(NORTH):
                    draw_n_to_e_bit(x,y);
                break;

                case(SOUTH):
                    draw_s_to_e_bit(x,y);
                break;
            }
        break;

        case(SOUTH):
            switch(previousbit)
            {
                case(SOUTH):
                case(NORTH):
                    draw_vertical_bit(x,y);
                break;
            
                case(EAST):
                    draw_e_to_s_bit(x,y);
                break;

                case(WEST):
                    draw_w_to_s_bit(x,y);
                break;
            }
        break;

        case(WEST): 
            switch(previousbit)
            {
                case(EAST):
                case(WEST):             
                    draw_horizontal_bit(x,y);
                break;  

                case(SOUTH):
                    draw_s_to_w_bit(x,y);
                break;

                case(NORTH):
                    draw_n_to_w_bit(x,y);
                break;
            }
        break;
    }
}

/*
** Death 'sequence' and end game stuff.
*/
void die (void)
{
    int n=100;
    int count;
    char pscore[18];
    /*Flashy death sequence (flashy as in 'flashes')*/
    for(count=0;count<24;count++)
    {
        rb->sleep(HZ/n);
        rb->lcd_clear_display();
        draw_apple();
        rb->lcd_update();

        rb->sleep(HZ/n);
        redraw();
        rb->lcd_update();
    }
    
    rb->lcd_clear_display();
    draw_apple();
    rb->lcd_update();
    rb->lcd_clear_display();
    
    applecount=0;

    rb->lcd_getstringsize("Dead",&strwdt,&strhgt);
    rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt,"Dead");
    
    rb->snprintf(pscore,sizeof(pscore),"Your Score %d",score);
    rb->lcd_getstringsize(pscore,&strwdt,&strhgt);
    rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt * 2 + 2,pscore);

    if (score>hiscore)
    {
        hiscore=score;
        rb->lcd_getstringsize("New High Score!",&strwdt,&strhgt);
        rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt * 4 + 2,"New High Score!");
    }
    else 
    {
        rb->snprintf(phscore,sizeof(phscore),"High Score: %d",hiscore);
        rb->lcd_getstringsize(phscore,&strwdt,&strhgt);
        rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt * 6,phscore);
    }
    rb->lcd_update();
    rb->sleep(3*HZ);
    dead=1;
}

/*
** Check for collision. TODO: Currently this
** sets of the death sequence. What we want is it to only return a true/false
** depending on whether a collision occured.
*/
void collision ( int x, int y )
{
    int bdeath=0;


    switch (board[x][y]) 
    {
        case 0:

        break; 
        case -1:
            score = score + (1 * level);
            apple=0;
            applecountdown=2;
            applecount++;
            
            if(game_type==1)
            {
                if(num_apples_to_get == num_apples_to_got)
                {
                    level_from_file++;
                    if(level_from_file >= num_levels)
                    {
                        level_from_file = 1;
                        /*and increase the number of apples to pick up
                        before level changes*/
                        num_apples_to_get+=2;
                        game_b_level++;
                    }
                    rb->splash(HZ, true, "Level Completed!");
                    rb->lcd_clear_display();
                    new_level(level_from_file);
                    redraw();
                }
                else
                    num_apples_to_got++;
            }
        break;
        default:
            bdeath=1;
            break;
    }

    if(bdeath==1)
    {
        die();
        sillydir = dir;
        frames = -110;
    }
}

void move( void )
{
    int taildir;
    /*this actually sets the dir variable.*/
    get_direction();
    /*draw head*/
    switch (dir) 
    {
        case (NORTH):
            board[headx][heady]=NORTH;
            heady--;
            break;
        case (EAST):
            board[headx][heady]=EAST;
            headx++; 
            break;
        case (SOUTH):
            board[headx][heady]=SOUTH;
            heady++;
            break;
        case (WEST):
            board[headx][heady]=WEST;
            headx--;
            break;
    }
    
    if(headx == WIDTH)
        headx = 0;
    else if(headx < 0)
        headx = WIDTH-1;

    if(heady == HEIGHT)
        heady = 0;
    else if(heady < 0)
        heady = HEIGHT-1;
    
    rb->lcd_fillrect(CENTER_X+headx*MULTIPLIER,CENTER_Y+heady*MULTIPLIER,MODIFIER_1,MODIFIER_1);
    
    /*clear tail*/
    if(applecountdown <= 0) 
    {
        rb->lcd_set_drawmode(DRMODE_SOLID|DRMODE_INVERSEVID);
        rb->lcd_fillrect(CENTER_X+tailx*MULTIPLIER,CENTER_Y+taily*MULTIPLIER,MODIFIER_1,MODIFIER_1);
        rb->lcd_set_drawmode(DRMODE_SOLID);

        taildir = board[tailx][taily];
        board[tailx][taily] = 0;

        switch (taildir)
        {
            case(NORTH):
                taily--;
            break;

            case(EAST):
                tailx++;
            break;

            case(SOUTH):
                taily++;
            break;

            case(WEST):
                tailx--;
            break;
        }
        
        if(tailx == WIDTH)
            tailx = 0;
        else if(tailx < 0)
            tailx = WIDTH-1;

        if(taily == HEIGHT)
            taily = 0;
        else if(taily < 0)
            taily = HEIGHT-1;
    }
    else
        applecountdown--;
}

void frame (void)
{
    int olddir, noldx, noldy, temp;
    noldx  = headx;
    noldy  = heady;
    olddir = 0;  
    switch(dir)
    {
        case(NORTH):
            if(heady == HEIGHT-1)
                temp = 0;
            else
                temp = heady + 1;
            
            olddir = board[headx][temp];
        break;

        case(EAST):
            if(headx == 0)
                temp = WIDTH-1;
            else
                temp = headx - 1;

            olddir = board[temp][heady];
        break;

        case(SOUTH):
            if(heady == 0)
                temp = HEIGHT-1;
            else
                temp = heady - 1;

            olddir = board[headx][temp];
        break;

        case(WEST):
            if(headx == WIDTH-1)
                temp = 0;
            else
                temp = headx + 1;

            olddir = board[temp][heady];
        break;
    }

    move();
    
    /*
      now redraw the bit that was
      the tail, to something snake-like:
     */
    draw_snake_bit(dir, olddir, noldx, noldy);   
    
    collision(headx, heady);
    
    rb->lcd_update();
}

void game_pause (void) 
{
    int button;

    rb->lcd_clear_display();
    rb->lcd_getstringsize("Paused",&strwdt,&strhgt);
    rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,LCD_HEIGHT/2,"Paused");
    
    rb->lcd_update();
    while (1) 
    {
        button = rb->button_get(true);
        switch (button)
        {
            case SNAKE2_PLAYPAUSE:
                redraw();
                rb->sleep(HZ/2);
                return;

            default:
                if (rb->default_event_handler(button)==SYS_USB_CONNECTED) {
                    dead = 1;
                    quit = 2;
                    return;
                }
                break;
        }
    }
}

void game (void) 
{
    int button;

    redraw();
    /*main loop:*/
    while (1) 
    {
        if(frames==5) 
        {
           frame();
           if(frames>0) frames=0;
        }
        frames++;
        
        if(frames == 0)
        {
            die();
        }
        else
        {
            if(frames < 0)
            {
                if(sillydir != dir)
                {
                    /*it has, great set frames to a positive value again:*/
                    frames = 1;
                }
            }
        }
        
        if (dead) return;
                
        draw_apple();
       
        rb->sleep(HZ/speed);

        button = rb->button_get(false);
        switch (button)
        {
             case BUTTON_UP:
             case BUTTON_UP | BUTTON_REPEAT:             
                 if (dir != SOUTH) set_direction(NORTH);
                 break;

             case BUTTON_RIGHT:
             case BUTTON_RIGHT | BUTTON_REPEAT:
                 if (dir != WEST) set_direction(EAST); 
                 break;

             case BUTTON_DOWN:
             case BUTTON_DOWN | BUTTON_REPEAT:
                 if (dir != NORTH) set_direction(SOUTH);
                 break;

             case BUTTON_LEFT:
             case BUTTON_LEFT | BUTTON_REPEAT:
                 if (dir != EAST) set_direction(WEST);
                 break;

             case SNAKE2_QUIT:
                 dead=1;
                 return;

             case SNAKE2_PLAYPAUSE:
                 game_pause();
                 break;

             default:
                 if (rb->default_event_handler(button)==SYS_USB_CONNECTED) {
                     quit = 2;
                     return;
                 }
                 break;
        }
    }

}

void game_init(void) 
{
    int button;
    char plevel[30];

    dead=0;
    apple=0;
    score=0;
    applecount=0;

    clear_board();
    load_level( level_from_file );
    
    while (1) 
    {    
        rb->lcd_clear_display();
        redraw();

#if LCD_WIDTH >= 160 && LCD_HEIGHT >= 128

        rb->lcd_set_drawmode(DRMODE_FG);
        rb->lcd_mono_bitmap(snakebmp,0,0,BMPWIDTH_snakebmp,BMPWIDTH_snakebmp);
        rb->lcd_set_drawmode(DRMODE_SOLID);

        rb->snprintf(plevel,sizeof(plevel),"%d",level);
        rb->lcd_getstringsize(plevel,&strwdt,&strhgt);
        rb->lcd_putsxy(42-strwdt/2,25, plevel);

        rb->snprintf(plevel,sizeof(plevel),"%d",level_from_file);
        rb->lcd_getstringsize(plevel,&strwdt,&strhgt);
        rb->lcd_putsxy(121-strwdt/2,4, plevel);

        if(game_type==0){
            rb->lcd_getstringsize("A",&strwdt,&strhgt);
            rb->lcd_putsxy(34,4,"A");
        } 
        else{
            rb->lcd_getstringsize("B",&strwdt,&strhgt);
            rb->lcd_putsxy(34,4,"B");
        }

        rb->snprintf(phscore,sizeof(phscore),"%d",hiscore);
        rb->lcd_getstringsize(phscore,&strwdt,&strhgt);
        rb->lcd_putsxy(114-strwdt/2,25, phscore);   
 
#else
        rb->snprintf(plevel,sizeof(plevel),"Speed: %d",level);
        rb->lcd_getstringsize("Speed: 00",&strwdt,&strhgt);
        rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt+4, plevel);

        rb->snprintf(plevel,sizeof(plevel),"Maze:  %d",level_from_file);
        rb->lcd_getstringsize(plevel,&strwdt,&strhgt);
        rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt*2+4, plevel);

        if(game_type==0){
            rb->lcd_getstringsize("Game Type: A ",&strwdt,&strhgt);
            rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt*3+4,"Game Type: A");
        } 
        else{
            rb->lcd_getstringsize("Game Type: B ",&strwdt,&strhgt);
            rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt*3+4,"Game Type: B");
        }

        rb->snprintf(phscore,sizeof(phscore),"Hi Score: %d",hiscore);
        rb->lcd_getstringsize(phscore,&strwdt,&strhgt);
        rb->lcd_putsxy((LCD_WIDTH - strwdt)/2,strhgt*4+4, phscore);
#endif

        rb->lcd_update();

        button=rb->button_get(true);
        switch (button)
        {
            case SNAKE2_LEVEL_UP:
#ifdef SNAKE2_LEVEL_UP2
            case SNAKE2_LEVEL_UP2:
#endif
                if (level<10) 
                    level+=1;
                break;
            case SNAKE2_LEVEL_DOWN:
#ifdef SNAKE2_LEVEL_DOWN2
            case SNAKE2_LEVEL_DOWN2:
#endif
                if (level>1)
                    level-=1;
                break;
            case SNAKE2_QUIT:
                quit=1;
                return;
                break;
            case SNAKE2_PLAYPAUSE:
                speed = level*20;
                return;
                break;
            case SNAKE2_SELECT_TYPE:
                if(game_type==0)game_type=1; else game_type=0;
                break;
            case SNAKE2_SELECT_MAZE:
                
                level_from_file++;
                if(level_from_file > num_levels)
                {
                    level_from_file = 1;
                }
                
                load_level( level_from_file );
                
                break;
            default:
                if (rb->default_event_handler(button)==SYS_USB_CONNECTED) {
                    quit = 2;
                    return;
                }
                break;
        }
    }

}

enum plugin_status plugin_start(struct plugin_api* api, void* parameter)
{
    TEST_PLUGIN_API(api);
    (void)(parameter);
    rb = api;

    /* Lets use the default font */
    rb->lcd_setfont(FONT_SYSFIXED);
    load_all_levels();

    if (num_levels == 0) {
        rb->splash(HZ*2, true, "Failed loading levels!");
        return PLUGIN_OK;
    }

    iohiscore();

    while(quit==0)
    {
      game_init(); 
      rb->lcd_clear_display();
      frames=1;
      
      if(quit==0)
      {
          init_snake();
          
          /*Start Game:*/
          game();
      }
    }
    
    iohiscore();
    return (quit==1) ? PLUGIN_OK : PLUGIN_USB_CONNECTED;
}

#endif
