
'---
' Set up SAPI for clip generation
'---

Public Sub VoiceInit()

'--- 

 Set Shell = CreateObject("WScript.Shell")
 Set FSO   = CreateObject("Scripting.FileSystemObject")
 dQ        = Chr(34)    ' double quote - preferable to writing """" to get "
 sP        = Chr(32)    ' space character
 ScriptDir = FSO.GetFile(Wscript.ScriptFullName).ParentFolder

 Set Log_file = FSO.CreateTextFile(ScriptDir&"\voiceBox.log")
 IniFile      = ScriptDir&"\voiceBox.ini"

'--- 

 On Error Resume Next ' skip to next line on error

 Set spkr = WSCript.CreateObject("SAPI.SpVoice")

 If Err.Number <> 0 Then

   MsgBox "You do not have Microsoft Speech installed."

   Err.clear
   Log_file.Close
   WScript.Quit

 End If

'--- Attempt to load voice.

 Set spkr.Voice = spkr.GetVoices("Language=409").Item(0)

 If Err.Number <> 0 Then

   MsgBox "You do not seem to have a voice installed. Exiting."

   Err.clear
   Log_file.Close
   Wscript.Quit

 End If

 On Error GoTo 0 ' reset error handling
 Err.clear ' in case we have more code, we clear the current error

'--- Set speech characteristics - volume and rate (no pitch?)

 spkr.Rate   = 1.     '-10 <--> +10
 spkr.Volume = 100    '  0 <--> 100

 Set SpFS = Wscript.CreateObject("SAPI.SpFileStream")
 SpFS.Format.Type = Audio_Format

'--- Check for existence of required lame.exe

 encodeApp = ScriptDir&"\lame.exe"

 If (not FSO.FileExists(encodeApp)) Then

   msgbox "Unable to locate MP3 encoding executable:"&_
           vbcrlf&vbcrlf&encodeApp&_
           vbcrlf&vbcrlf&"Exiting!"

   Log_file.Close
   WScript.Quit

 End If

 Log_file.WriteLine("Encoding application: "&encodeApp)

 If FSO.FileExists(IniFile) Then

   Set MyFile   = FSO.OpenTextFile(IniFile,ForReading)
   strIniConfig = MyFile.ReadAll
   MyFile.Close
   Set MyFile = Nothing

 Else

   strIniConfig = "Overwrite_dotTalk = False" & VBCRLF & _
                  "Overwrite_dotWav  = True"  & VBCRLF & _
                  "RemoveWav         = True"  & VBCRLF & _
                  "VoiceFolders      = True"  & VBCRLF & _
                  "VoiceFiles        = False"

 End If

 ExecuteGlobal strIniConfig

End Sub

'--- Subroutine to enumerate all folders and "voiced" files in a folder.
'--- Traverses folders recursively. See function "isVoiced" for filtering rules.

Public Sub VoiceCheck(Item)

 Dim ThisFolder, LastSlash, LastDot, ClipSpeak, WavFile, TalkFile

 If (FSO.FolderExists(Item)) Then

'----- Open the parent folder

   Set ThisFolder = FSO.GetFolder(Item)

'--- Process items in this folder

   If (VoiceFolders) Then

     LastSlash = InStrRev(Item,"\",-1,1)
     ClipSpeak = Right(Item,Len(Item)-LastSlash)
     WavFile  = Item&"\_dirname.wav"
     TalkFile = Item&"\_dirname.talk"

     Log_file.WriteLine("Folder: "&Item&" voiced")

     Call TextToMP3(ClipSpeak,WavFile,TalkFile)

   Else

     Log_file.WriteLine("Folder: "&Item&" not voiced")

   End If

   If (ThisFolder.Files.Count <> 0) Then

     For Each File In ThisFolder.Files

       If (VoiceFiles) Then

         ClipSpeak = File.Name

         If (isVoiced(File.Name)) Then

           WavFile  = Item&"\"&ClipSpeak&".wav"
           TalkFile = Item&"\"&ClipSpeak&".talk"

           Log_file.WriteLine("File: "&Item&"\"&ClipSpeak&" voiced")

           LastDot   = InStrRev(ClipSpeak,".",-1,1)
           ClipSpeak = Left(ClipSpeak,LastDot)

           Call TextToMP3(ClipSpeak,WavFile,TalkFile)

         Else

           Log_file.WriteLine("File: "&Item&"\"&ClipSpeak&" not voiced")

         End If

       End If

     Next

   End If

'--- Process subfolders

   If (ThisFolder.SubFolders.Count <> 0) Then

     For Each Folder In ThisFolder.SubFolders

       Call VoiceCheck(Folder)

     Next

   End If

   Set ThisFolder = Nothing

 ElseIf (FSO.FileExists(Item)) Then

   If (VoiceFiles) Then

     If (isVoiced(Item)) Then

       LastSlash = InStrRev(Item,"\",-1,1)
       ClipSpeak = Right(Item,Len(Item)-LastSlash)
       WavFile  = Item&".wav"
       TalkFile = Item&".talk"

       Log_file.WriteLine("File: "&Item&" voiced")

       LastDot   = InStrRev(ClipSpeak,".",-1,1)
       ClipSpeak = Left(ClipSpeak,LastDot)

       Call TextToMP3(ClipSpeak,WavFile,TalkFile)

     Else

       Log_file.WriteLine("Voicing File: "&Item&" not voiced")

     End If

   End If

 Else

   Log_file.WriteLine("Argument: "&Item&" not found")

 End If

End Sub 'voiceCheck

'===============================================================================
' Function to determine whether a given file is to be voiced or not.
' Edit the file name matching rules below as you see fit.
' Updated to handle new iRiver formats and additional Archos-supported formats,
' now checks for last '.' and assumes remainder is extension. (Jens Arnold)
'===============================================================================

function isVoiced(Name)

  Dim extension

  isVoiced = false

'--- General case
  extpos = InStrRev(Name, ".")
 
  If (extpos > 0 and extpos < Len(Name)) Then
 
    extension = LCase(Mid(Name, extpos + 1))
 
' First 5 extensions are supported on all units, rest are iRiver only

    If ((extension = "mp2")  or _
        (extension = "mp3")  or _
        (extension = "mpa")  or _
        (extension = "m3u")  or _
        (extension = "cfg")  or _
        (extension = "mp1")  or _
        (extension = "ogg")  or _
        (extension = "mpc")  or _
        (extension = "a52")  or _
        (extension = "ac3")  or _
        (extension = "mp4")  or _
        (extension = "wav")  or _
        (extension = "flac") or _
        (extension = "m4a")  or _
        (extension = "wv"))  Then
 
      isVoiced = true

    End If

  End If

end function 'isVoiced


Public Sub TextToMP3(Text,WaveFile,MP3File)

 Dim cmdRun, retval

 If (Overwrite_dotTalk or (not FSO.FileExists(MP3File))) Then

   If (Overwrite_dotWav or not FSO.FileExists(WaveFile)) Then

'--- Strip file extension

'--- Speak text directly to the .wav file

     Log_file.WriteLine("-->Speaking "&Text)

     SpFS.Open WaveFile, SSFMCreateForWrite, False
     Set spkr.AudioOutputStream = SpFS
     Text = Replace(Text,"_"," ")
     Text = Replace(Text,"-"," ")
     Text = Replace(Text,","," ")
     Text = Replace(Text,"."," ")
     Text = Replace(Text,";"," ")
     Text = Replace(Text,"("," ")
     Text = Replace(Text,")"," ")
     Text = Replace(Text,"+"," ")
     Text = Replace(Text,"="," ")
     Text = Replace(Text,"~"," ")
     Text = Replace(Text,"  "," ")
     spkr.Speak(Text)
     SpFS.Close

   End If

'--- Send command line to wave encoding application.
'--- Quote encoder path, just to be safe. (spaces in absolute pathname?)

   If (FSO.FileExists(WaveFile)) Then

     cmdRun = dQ&encodeApp&dQ&sP&LameOpts&sP&dQ&WaveFile&dQ&sP&dQ&Mp3File&dQ
     Log_file.WriteLine("  -->Encoding "&WaveFile)
     Log_file.WriteLine("  -->Storing  "&MP3File)
     Log_file.WriteLine cmdRun

     retval = Shell.Run(cmdRun,7,true)

   End If

 Else

     Log_file.WriteLine("  -->Already exists "&MP3File)

 End If

'---  Delete the wave file after encoding if RemoveWav is set to true

 If (RemoveWav and FSO.FileExists(WaveFile)) Then

   cmdRun = "  -->Deleting file "&WaveFile
   Log_file.WriteLine cmdRun

   FSO.DeleteFile(WaveFile)

 End If

End Sub
